/*
 * Decompiled with CFR 0.152.
 */
package com.james.tinkerscalibration.modifiers;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.player.PlayerEvent;
import org.jetbrains.annotations.Nullable;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.modifiers.hook.ConditionalStatModifierHook;
import slimeknights.tconstruct.library.modifiers.util.ModifierHookMap;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.stat.FloatToolStat;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.tools.modifiers.upgrades.general.ReinforcedModifier;

public class IgneousModifier
extends Modifier
implements ConditionalStatModifierHook {
    private final ResourceLocation KEY = new ResourceLocation("tinkerscalibration", "igneous_mod");
    private static final Component UNBREAKING = TConstruct.makeTranslation((String)"modifier", (String)"igneous.unbreaking");

    protected void registerHooks(ModifierHookMap.Builder hookBuilder) {
        hookBuilder.addHook((Object)this, TinkerHooks.CONDITIONAL_STAT);
    }

    public float getEntityDamage(@Nonnull IToolStackView tool, int level, @Nonnull ToolAttackContext context, float baseDamage, float damage) {
        ModDataNBT persistantData = tool.getPersistentData();
        if (persistantData.contains(this.KEY, 5)) {
            float value = persistantData.getFloat(this.KEY);
            return (float)((double)damage * (1.0 + (double)value * 0.1));
        }
        return super.getEntityDamage(tool, level, context, baseDamage, damage);
    }

    public void onBreakSpeed(@Nonnull IToolStackView tool, int level, @Nonnull PlayerEvent.BreakSpeed event, @Nonnull Direction sideHit, boolean isEffective, float miningSpeedModifier) {
        ModDataNBT persistantData = tool.getPersistentData();
        if (persistantData.contains(this.KEY, 5)) {
            float value = persistantData.getFloat(this.KEY);
            event.setNewSpeed((float)((double)event.getOriginalSpeed() * (1.0 + (double)value * 0.1)));
        }
    }

    public int getPriority() {
        return 120;
    }

    public int onDamageTool(IToolStackView tool, int level, int amount, @javax.annotation.Nullable LivingEntity holder) {
        ModDataNBT persistantData = tool.getPersistentData();
        if (persistantData.contains(this.KEY, 5)) {
            float value = persistantData.getFloat(this.KEY);
            if (value >= (float)level / 5.0f) {
                return ReinforcedModifier.damageReinforced((int)amount, (float)((float)(0.1 * (double)level)));
            }
            return ReinforcedModifier.damageReinforced((int)amount, (float)(value / 10.0f));
        }
        return amount;
    }

    public void onRemoved(IToolStackView tool) {
        if (tool.getModifierLevel(this.getId()) == 0) {
            tool.getPersistentData().remove(this.KEY);
        }
    }

    public float modifyStat(IToolStackView tool, ModifierEntry modifier, LivingEntity living, FloatToolStat stat, float baseValue, float multiplier) {
        ModDataNBT persistantData = tool.getPersistentData();
        if (persistantData.contains(this.KEY, 5)) {
            float value = persistantData.getFloat(this.KEY);
            if (stat == ToolStats.DRAW_SPEED) {
                return (float)((double)baseValue * (1.0 + (double)value * 0.1));
            }
            if (stat == ToolStats.PROJECTILE_DAMAGE) {
                return (float)((double)baseValue * (1.0 + (double)value * 0.1));
            }
        }
        return baseValue;
    }

    public void onInventoryTick(@Nonnull IToolStackView tool, int level, @Nonnull Level world, @Nonnull LivingEntity holder, int itemSlot, boolean isSelected, boolean isCorrectSlot, ItemStack stack) {
        ModDataNBT persistantData = tool.getPersistentData();
        if (!world.f_46443_ && holder.f_19797_ % 100 == 0 && holder.m_21211_() != stack && isSelected && holder.m_6060_() && persistantData.getFloat(this.KEY) <= (float)(5 * level) && RANDOM.nextFloat() <= 0.6f * (float)level) {
            persistantData.putFloat(this.KEY, persistantData.getFloat(this.KEY) + 0.1f);
        }
    }

    public void addInformation(@Nonnull IToolStackView tool, int level, @Nullable Player player, @Nonnull List<Component> tooltip, @Nonnull TooltipKey tooltipKey, @Nonnull TooltipFlag tooltipFlag) {
        if (player != null) {
            ModDataNBT persistantData = tool.getPersistentData();
            boolean harvest = tool.hasTag(TinkerTags.Items.HARVEST);
            if (persistantData.contains(this.KEY, 5)) {
                float value = persistantData.getFloat(this.KEY);
                this.addPercentTooltip((Component)new TranslatableComponent("modifier.tinkerscalibration.modifier.igneous.attack_damage"), (double)value * 0.1, tooltip);
                if (harvest) {
                    this.addPercentTooltip((Component)new TranslatableComponent("modifier.tinkerscalibration.modifier.igneous.mining_speed"), (double)value * 0.1, tooltip);
                } else {
                    this.addPercentTooltip((Component)new TranslatableComponent("modifier.tinkerscalibration.modifier.igneous.draw_speed"), (double)value * 0.1, tooltip);
                }
                if (value >= (float)level) {
                    this.addPercentTooltip(UNBREAKING, 0.1 * (double)level, tooltip);
                } else if (value < (float)level) {
                    this.addPercentTooltip(UNBREAKING, value / 10.0f, tooltip);
                }
                tooltip.add((Component)new TranslatableComponent("modifier.tinkerscalibration.igneous.cap").m_130940_(ChatFormatting.DARK_PURPLE));
            }
        }
    }
}

